/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8260.DeviceView;

import ibm.nways.atmSW.AtmView;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.I18NMsgFormat;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.common.OctetString;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.jdm8260.DeviceView.Builder;
import ibm.nways.jdm8260.DeviceView.BuilderLike;
import ibm.nways.jdm8260.DeviceView.Hub8250_06hc;
import ibm.nways.jdm8260.DeviceView.Hub8265_17;
import ibm.nways.jdm8260.DeviceView.HubInfoLike;
import ibm.nways.jdm8260.DeviceView.HubLike;
import ibm.nways.jdm8260.DeviceView.HubUnknown;
import ibm.nways.jdm8260.DeviceView.LateStatusLike;
import ibm.nways.jdm8260.DeviceView.LeafCompositeLike;
import ibm.nways.jdm8260.DeviceView.ModuleLike;
import ibm.nways.jdm8260.DeviceView.Module_161001;
import ibm.nways.jdm8260.DeviceView.NetworksWindow;
import ibm.nways.jdm8260.DeviceView.NetworksWindowLike;
import ibm.nways.jdm8260.DeviceView.PortLike;
import ibm.nways.jdm8260.DeviceView.StatusAttachInfo;
import ibm.nways.jdm8260.DeviceView.StatusRefLike;
import ibm.nways.jdm8260.MibInfo;
import ibm.nways.jdm8260.MibValue;
import ibm.nways.launcher.LaunchContext;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.awt.Point;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class Hub
implements HubLike,
HubInfoLike {
    private String hubIp = "0.0.0.0";
    protected GraphicContainer graphicContainer = new GraphicContainer();
    protected GraphicContainer container = new GraphicContainer();
    private GraphicPanel graphicPanel;
    private GraphicPanel atmView;
    private Vector components = new Vector();
    protected JdmBrowser jdmBrowser;
    protected GenModel atmSWInterfaceModel;
    protected GenModel atmSWModel;
    protected GenModel viewModel;
    protected MibInfo snmpInfo;
    protected NetworksWindowLike networksWindow;
    protected ResourceBundle bundle = ResourceBundle.getBundle("ibm.nways.jdm8260.DeviceView.GraphicResources");
    protected StatusAttachThread statusThread;
    protected MACAddressAttachThread macAddressThread;
    protected Vector stack = new Vector();
    protected Vector lateStack = new Vector();
    protected Vector macAddressStack = new Vector();
    protected Hashtable macAddressTokenRingPorts;
    public static String PROPERTIES_FILE = "properties/8260.txt";
    private Vector launchableItems = new Vector();

    public void dispose() {
        if (this.macAddressThread != null) {
            this.macAddressThread.interrupt();
            this.macAddressThread = null;
        }
        if (this.statusThread != null) {
            this.statusThread.interrupt();
            this.statusThread = null;
        }
        if (this.networksWindow != null) {
            this.networksWindow.dispose();
            this.networksWindow = null;
        }
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            ((LeafCompositeLike)enumeration.nextElement()).dispose();
        }
        this.stack.removeAllElements();
        this.lateStack.removeAllElements();
        this.macAddressStack.removeAllElements();
        if (this.graphicPanel != null) {
            this.graphicPanel.dispose();
            this.graphicPanel = null;
        }
        if (this.graphicContainer != null) {
            this.graphicContainer.dispose();
            this.graphicContainer = null;
        }
        if (this.container != null) {
            this.container.dispose();
            this.container = null;
        }
        this.snmpInfo = null;
        this.jdmBrowser = null;
        this.bundle = null;
        if (this.macAddressTokenRingPorts != null) {
            this.macAddressTokenRingPorts.clear();
            this.macAddressTokenRingPorts = null;
        }
        this.components.removeAllElements();
    }

    public MibInfo getMibInfo() {
        return this.snmpInfo;
    }

    public JdmBrowser getBrowser() {
        return this.jdmBrowser;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public NetworksWindowLike getNetworksWindow() {
        return this.networksWindow;
    }

    public void showNetwork(String string) {
        if (this.networksWindow != null && this.networksWindow.showNetwork(string) && this.graphicContainer != null) {
            this.graphicContainer.invalidate();
            this.graphicContainer.validate();
        }
    }

    public void draw() {
        String string = "draw";
        GraphicHelp graphicHelp = new GraphicHelp((BrowserApplet)this.jdmBrowser, new Point(0, 0), new HelpRef("ibm.nways.jdm8265", "ibm.nways.jdm8265.BoxGraphic.html"));
        this.container.add((GraphicComponent)graphicHelp);
        this.graphicContainer.setLocation(20, 20);
        Enumeration enumeration = this.components.elements();
        while (enumeration.hasMoreElements()) {
            LeafCompositeLike leafCompositeLike = (LeafCompositeLike)enumeration.nextElement();
            long l = System.currentTimeMillis();
            try {
                leafCompositeLike.draw();
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 2)) {
                    RAS.trace(19, 2, this, string, "Exception drawing object -> " + leafCompositeLike.getClass().getName());
                }
                RAS.logException(19, 2, this, string, exception);
            }
            long l2 = System.currentTimeMillis();
            if (!RAS.isEnabled(19, 2)) continue;
            RAS.trace(19, 2, this, string, "Time to draw component of Hub -> " + (l2 - l));
        }
        this.container.add(this.graphicContainer);
        this.container.doLayout();
        this.cleanMacAddressAssignment();
    }

    public boolean isCPSW() {
        return false;
    }

    public boolean is8250() {
        return false;
    }

    public void startThreads() {
        this.stopThreads();
        this.statusThread = new StatusAttachThread();
        this.statusThread.setName("Status Attach");
        this.statusThread.start();
        if (!this.macAddressStack.isEmpty()) {
            this.macAddressThread = new MACAddressAttachThread();
            this.macAddressThread.setName("MAC Address Attach");
            this.macAddressThread.start();
        }
    }

    public void stopThreads() {
        if (this.statusThread != null) {
            this.statusThread.interrupt();
            this.stack.removeAllElements();
            this.lateStack.removeAllElements();
            this.statusThread = null;
        }
        if (this.macAddressThread != null) {
            this.macAddressThread.interrupt();
            this.macAddressStack.removeAllElements();
            this.macAddressThread = null;
        }
    }

    public final void add(LeafCompositeLike leafCompositeLike) {
        if (leafCompositeLike != null) {
            this.components.addElement(leafCompositeLike);
        }
    }

    public final GraphicPanel getGraphicPanel() {
        URL uRL;
        String string = "getGraphicPanel";
        if (this instanceof HubUnknown) {
            return null;
        }
        String string2 = "8260.layout.scheme";
        String string3 = "8260.layout.fractions";
        if (this instanceof Hub8265_17) {
            string2 = "8265.layout.scheme";
            string3 = "8265.layout.fractions";
        } else if (this.is8250()) {
            if (this instanceof Hub8250_06hc) {
                string2 = "8250HC.layout.scheme";
                string3 = "8250HC.layout.fractions";
            } else {
                string2 = "8250.layout.scheme";
                string3 = "8250.layout.fractions";
            }
        }
        Properties properties = null;
        try {
            uRL = new URL(this.jdmBrowser.getDocumentBase(), PROPERTIES_FILE);
            properties = new Properties();
            properties.load(uRL.openStream());
        }
        catch (Exception exception) {
            properties = null;
            RAS.logException(19, 2, this, string, exception);
            RAS.logError(19, 2, this, string, "EXCEPTION_GETTING_PROPERTIES", (Object)PROPERTIES_FILE);
        }
        uRL = (JdmLayout)this.jdmBrowser.getLayout();
        if (properties != null) {
            Integer n = new Integer((String)((Hashtable)properties).get(string2));
            uRL.setScheme(n);
            String string4 = (String)((Hashtable)properties).get(string3);
            StringTokenizer stringTokenizer = new StringTokenizer(string4);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string5).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string, "Bad layout.fractions parameter -> " + numberFormatException.getMessage());
                    }
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                uRL.setFracts(fArray);
            }
        }
        try {
            this.atmSWModel = (GenModel)((GenModel)this.jdmBrowser.getModel()).getComponent("AtmSW");
            if (this.atmSWModel != null) {
                this.viewModel = (GenModel)this.atmSWModel.getComponent("AtmView");
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        if (this.graphicPanel == null) {
            this.graphicPanel = new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)this.container);
        }
        return this.graphicPanel;
    }

    public void switchToDeviceView() {
        this.jdmBrowser.setGraphicPanel(this.graphicPanel);
    }

    public void switchToAtmView() {
        if (this.atmView == null) {
            AtmView atmView = new AtmView((BrowserApplet)this.jdmBrowser, this.viewModel, this.getAtmSWInterfaceModel());
            this.atmView = new GraphicPanel((GraphicHandler)this.jdmBrowser, (Component)atmView);
        }
        this.jdmBrowser.setGraphicPanel(this.atmView);
    }

    public final void setCommonInformation(JdmBrowser jdmBrowser, MibInfo mibInfo) {
        String string = "setCommonInformation";
        this.jdmBrowser = jdmBrowser;
        this.snmpInfo = mibInfo;
        try {
            SnmpContextModel snmpContextModel = (SnmpContextModel)((GenModel)this.jdmBrowser.getModel()).getComponent("_ContextInfo");
            ModelInfo modelInfo = snmpContextModel.getConfig();
            this.hubIp = (String)((Object)modelInfo.get("Config.Address"));
            return;
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
            return;
        }
    }

    public String getFlyOver(String string) {
        Object[] objectArray = new Object[]{this.hubIp};
        I18NMsgFormat i18NMsgFormat = new I18NMsgFormat("ibm.nways.jdm8260.DeviceView.GraphicResources", string, objectArray);
        return i18NMsgFormat.getTranslation();
    }

    public GraphicActionNavigate getAction() {
        String string = "getAction";
        GraphicActionNavigate graphicActionNavigate = null;
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            GenModel genModel2 = (GenModel)genModel.getComponent("System");
            graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.jdmBrowser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", (RemoteModel)genModel2), null);
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        return graphicActionNavigate;
    }

    public abstract Point getModulePosition(int var1, ModuleLike var2);

    public abstract Point getModuleStatusIconPosition(int var1, ModuleLike var2);

    protected int getDirectionMultiplier() {
        return 1;
    }

    public void discoverChildren() {
        String string;
        block16: {
            string = "discoverChildren";
            if (RAS.isEnabled(19, 2)) {
                RAS.enter(19, 2, this, string);
            }
            BuilderLike builderLike = Builder.getInstance();
            this.networksWindow = new NetworksWindow();
            try {
                GenModel genModel = (GenModel)((GenModel)this.jdmBrowser.getModel()).getComponent("Modules");
                Serializable serializable = this.snmpInfo.getVar("ocModType");
                if (!(serializable instanceof Vector)) break block16;
                if (RAS.isEnabled(19, 2)) {
                    RAS.trace(19, 2, this, string, "Modules found in HUB");
                }
                Vector vector = (Vector)serializable;
                Object var6_7 = null;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object object;
                    MibValue mibValue = (MibValue)enumeration.nextElement();
                    int[] nArray = mibValue.getIndexesArray();
                    int n = nArray[0];
                    int n2 = nArray[1];
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string, "Found module " + mibValue.getValue() + " in slot " + n + ", sub-slot " + n2);
                    }
                    if (n2 != 1) continue;
                    long l = System.currentTimeMillis();
                    GenModel genModel2 = null;
                    ModelInfo modelInfo = new ModelInfo();
                    modelInfo.add("Index.ModSlotIndex", new Integer(n));
                    modelInfo.add("Index.ModSubSlotIndex", new Integer(n2));
                    try {
                        object = genModel.getRowRef(modelInfo);
                        genModel2 = (GenModel)object.getComponent("ModType");
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 2, this, string, exception);
                    }
                    try {
                        object = builderLike.buildModule(this, n, n2, mibValue.getValue(), this.graphicContainer, genModel2);
                        int n3 = n - object.getGrowthDirection() * this.getDirectionMultiplier();
                        Point point = this.getModulePosition(n3, (ModuleLike)object);
                        if (point != null) {
                            Serializable serializable2;
                            object.setLocation(point);
                            Point point2 = this.getModuleStatusIconPosition(n3, (ModuleLike)object);
                            if (point2 != null) {
                                object.addModuleStatusIcon(point2);
                            }
                            if (object instanceof Module_161001 && (serializable2 = this.snmpInfo.getVar("ocModType", "." + (n + 1) + ".1")) instanceof MibValue) {
                                enumeration.nextElement();
                            }
                            this.add((LeafCompositeLike)object);
                        }
                    }
                    catch (Exception exception) {
                        if (RAS.isEnabled(19, 2)) {
                            RAS.trace(19, 2, this, string, "Exception building component. Slot -> " + n + " Sub-slot -> " + n2 + " ModType -> " + mibValue.getValue());
                        }
                        RAS.logException(19, 2, this, string, exception);
                    }
                    long l2 = System.currentTimeMillis();
                    if (RAS.isEnabled(19, 2)) {
                        RAS.trace(19, 2, this, string, "Time to build module in slot " + n + ", sub-slot " + n2 + "-> " + (l2 - l));
                    }
                    var6_7 = null;
                }
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
            }
        }
        if (RAS.isEnabled(19, 2)) {
            RAS.exit(19, 2, this, string);
        }
    }

    public void askStatus(GenModel genModel, GraphicImage graphicImage, ModelInfo modelInfo, LeafCompositeLike leafCompositeLike) {
        this.stack.addElement(new StatusAttachInfo(genModel, graphicImage, modelInfo, leafCompositeLike));
    }

    public void askStatus(LateStatusLike lateStatusLike) {
        this.lateStack.addElement(lateStatusLike);
    }

    public void askMACAddress(PortLike portLike) {
        this.macAddressStack.addElement(portLike);
    }

    public String getTRPortMACAddress(int n, int n2) {
        Object v;
        if (this.macAddressTokenRingPorts == null) {
            this.macAddressTokenRingPorts = this.createMacAddressAssignment();
        }
        if ((v = this.macAddressTokenRingPorts.get("." + n + "." + n2)) == null) {
            return "";
        }
        return (String)v;
    }

    private Hashtable createMacAddressAssignment() {
        String string = "createMacAddressAssignment";
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            GenModel genModel = (GenModel)this.jdmBrowser.getModel();
            GenModel genModel2 = (GenModel)genModel.getComponent("OcTRSummaryInfo");
            try {
                Vector vector = genModel2.getRestOfInfo("TRSummaryInfo", "default", null, null);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    ModelInfo modelInfo = (ModelInfo)enumeration.nextElement();
                    if (modelInfo == null) continue;
                    Serializable serializable = modelInfo.get("TRSummaryInfo.MapSummary32Stations");
                    if (serializable instanceof OctetString) {
                        byte[] byArray = ((OctetString)serializable).value;
                        String string2 = serializable.toString().toUpperCase();
                        int n = 0;
                        int n2 = 0;
                        try {
                            while (true) {
                                int n3 = byArray[n + 6] & 0xFF;
                                int n4 = byArray[n + 7] & 0xFF;
                                String string3 = string2.substring(n2, n2 + 12);
                                n += 8;
                                n2 += 16;
                                hashtable.put("." + n3 + "." + n4, string3);
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            continue;
                        }
                        catch (Exception exception) {
                            RAS.logException(19, 2, this, string, exception);
                            continue;
                        }
                    }
                    if (!RAS.isEnabled(19, 2)) continue;
                    RAS.trace(19, 2, this, string, "Error when retrieving Token Ring MAC addresses");
                }
            }
            catch (Exception exception) {
                if (RAS.isEnabled(19, 2)) {
                    RAS.trace(19, 2, this, string, "This agent implements neither the trnetMapSummaryTable nor the ocTRnetMapSummaryTable");
                }
            }
        }
        catch (Exception exception) {
            RAS.logException(19, 2, this, string, exception);
        }
        return hashtable;
    }

    private void cleanMacAddressAssignment() {
        if (this.macAddressTokenRingPorts != null) {
            this.macAddressTokenRingPorts.clear();
            this.macAddressTokenRingPorts = null;
        }
    }

    public int getNumberOfLaunchableItems() {
        return this.launchableItems.size();
    }

    public void addLaunchContext(NavigationContext navigationContext) {
        if (!this.launchableItems.isEmpty()) {
            navigationContext.put((Object)"launcherFolderContext", (Object)this.launchableItems);
        }
    }

    public void addLaunchableItem(String string, String string2, int n) {
        String string3 = "addLaunchableItem";
        if (string2 != null && !string2.equals("0.0.0.0")) {
            try {
                LaunchContext launchContext = new LaunchContext();
                launchContext.setSlotNumber(string, Integer.toString(n));
                launchContext.setIpAddress(string, string2);
                Object[] objectArray = new Object[]{launchContext.getName(string), new Integer(n)};
                I18NMsgFormat i18NMsgFormat = new I18NMsgFormat("ibm.nways.jdm8260.DeviceView.GraphicResources", "LaunchTitle", objectArray);
                launchContext.setNavTitle(string, i18NMsgFormat.getTranslation());
                this.launchableItems.addElement(launchContext.getProp(string));
                return;
            }
            catch (NullPointerException nullPointerException) {
                RAS.logException(19, 2, this, string3, (Exception)nullPointerException);
                return;
            }
        }
    }

    public String getHubIPAddress() {
        return this.hubIp;
    }

    public GenModel getAtmSWInterfaceModel() {
        block2: {
            String string = "getAtmSWInterfaceModel";
            if (this.atmSWInterfaceModel != null) break block2;
            try {
                this.atmSWInterfaceModel = (GenModel)((GenModel)this.jdmBrowser.getModel()).getComponent("AtmSWInterface");
            }
            catch (Exception exception) {
                RAS.logException(19, 2, this, string, exception);
            }
        }
        return this.atmSWInterfaceModel;
    }

    private class StatusAttachThread
    extends Thread {
        public void run() {
            Object object;
            int n;
            String string = "run";
            if (RAS.isEnabled(19, 2)) {
                RAS.enter(19, 2, this, string);
            }
            Vector vector = Hub.this.stack;
            synchronized (vector) {
                n = 0;
                while (n < Hub.this.stack.size()) {
                    if (this.isInterrupted()) break;
                    try {
                        object = (StatusAttachInfo)Hub.this.stack.elementAt(n);
                        RemoteStatus remoteStatus = null;
                        remoteStatus = ((StatusAttachInfo)object).info != null ? ((StatusAttachInfo)object).model.getStatusRefForRow(((StatusAttachInfo)object).info) : ((StatusAttachInfo)object).model.getStatus("default");
                        StatusProxy statusProxy = new StatusProxy(remoteStatus);
                        if (((StatusAttachInfo)object).image != null) {
                            ((StatusAttachInfo)object).image.setStatus((Status)statusProxy);
                        }
                        if (((StatusAttachInfo)object).object instanceof StatusRefLike) {
                            ((StatusRefLike)((Object)((StatusAttachInfo)object).object)).setStatusRef(statusProxy);
                        }
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 2, this, string, exception);
                    }
                    ++n;
                }
            }
            Hub.this.stack.removeAllElements();
            vector = Hub.this.lateStack;
            synchronized (vector) {
                try {
                    n = 0;
                    while (n < Hub.this.lateStack.size()) {
                        if (!this.isInterrupted()) {
                            object = (LateStatusLike)Hub.this.lateStack.elementAt(n);
                            object.statusesAttached();
                            ++n;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exception) {
                    RAS.logException(19, 2, this, string, exception);
                }
            }
            Hub.this.lateStack.removeAllElements();
            if (RAS.isEnabled(19, 2)) {
                RAS.exit(19, 2, this, string);
            }
        }

        StatusAttachThread() {
            Hub.this = Hub.this;
        }
    }

    private class MACAddressAttachThread
    extends Thread {
        public void run() {
            String string = "run";
            Vector vector = Hub.this.macAddressStack;
            synchronized (vector) {
                Enumeration enumeration = Hub.this.macAddressStack.elements();
                while (enumeration.hasMoreElements()) {
                    try {
                        if (this.isInterrupted()) break;
                        PortLike portLike = (PortLike)enumeration.nextElement();
                        boolean bl = portLike.findMACAddress();
                        if (!bl) continue;
                        GraphicImage graphicImage = portLike.getGraphicImage();
                        I18NMsgFormat i18NMsgFormat = portLike.getFlyOverText();
                        graphicImage.setFlyOver(new GraphicFlyOver(i18NMsgFormat.getTranslation()));
                    }
                    catch (Exception exception) {
                        RAS.logException(19, 2, this, string, exception);
                    }
                }
                Hub.this.macAddressStack.removeAllElements();
                return;
            }
        }

        MACAddressAttachThread() {
            Hub.this = Hub.this;
        }
    }
}

